package explorviz.hpc_monitoring.connector;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;

import com.lmax.disruptor.EventHandler;

import explorviz.hpc_monitoring.disruptor.ByteArrayEvent;

public class TCPConnector implements EventHandler<ByteArrayEvent> {
	private static final int MESSAGE_BUFFER_SIZE = 65536;

	private String providerUrl;
	private final int providerPort;

	private Socket socket;

	private BufferedOutputStream bufferedOutputStream;

	public TCPConnector(final String providerUrl, final int providerPort) {
		this.providerUrl = providerUrl;
		this.providerPort = providerPort;

		try {
			connect(providerUrl);
		} catch (final IOException e) {
			e.printStackTrace();
		}
	}

	private void connect(final String provider) throws IOException {
		socket = new Socket(providerUrl, providerPort);
		bufferedOutputStream = new BufferedOutputStream(
				socket.getOutputStream(), MESSAGE_BUFFER_SIZE);
	}

	public final void sendMessage(final byte[] message, final int length) {
		try {
			bufferedOutputStream.write(message, 0, length);
			// if (endOfBatch) {
			// bufferedOutputStream.flush();
			// }
		} catch (final IOException e) {
			e.printStackTrace();
		}
	}

	public final void cleanup() {
		disconnect();
	}

	private void disconnect() {
		if (socket.isConnected()) {
			try {
				socket.close();
			} catch (final IOException e) {
				System.out.println(e.toString());
			}
		}
	}

	public void setProvider(final String provider) {
		synchronized (this) {
			if (!provider.equals(providerUrl)) {
				disconnect();
				try {
					connect(provider);
					providerUrl = provider;
					notifyAll();
				} catch (final IOException e) {
					e.printStackTrace();
				}
			}
		}
	}

	@Override
	public void onEvent(final ByteArrayEvent event, final long sequence,
			final boolean endOfBatch) throws Exception {
		sendMessage(event.getValue(), event.getLength());
	}
}
