package explorviz.hpc_monitoring.filter.reduction;

import explorviz.hpc_monitoring.record.Trace;
import explorviz.hpc_monitoring.record.events.AbstractOperationEvent;

public class TraceAggregationBuffer {
    private Trace      accumulator;
    private final long bufferCreatedTimestamp;

    public TraceAggregationBuffer(final long bufferCreatedTimestamp) {
        this.bufferCreatedTimestamp = bufferCreatedTimestamp;
    }

    public long getBufferCreatedTimestamp() {
        return bufferCreatedTimestamp;
    }

    public Trace getAggregatedTrace() {
        return accumulator;
    }

    public void insertTrace(final Trace trace) {
        aggregate(trace);
    }

    private void aggregate(final Trace trace) {
        if (accumulator == null) {
            accumulator = trace;
        }
        else {
            final AbstractOperationEvent[] aggregatedRecords = accumulator
                    .getTraceEvents();
            final AbstractOperationEvent[] records = trace.getTraceEvents();
            for (int i = 0; i < aggregatedRecords.length; i++) {
                aggregatedRecords[i].getRuntime()
                        .merge(records[i].getRuntime());
            }

            accumulator.getRuntime().merge(trace.getRuntime());
        }
    }
}