package explorviz.hpc_monitoring.record.events;

import kieker.common.record.IMonitoringRecord;
import kieker.common.record.flow.IFlowRecord;
import explorviz.hpc_monitoring.record.RuntimeStatisticInformation;

public class AbstractOperationEvent implements IFlowRecord {
    private static final long                 serialVersionUID = 1224383944280820758L;
    private final long                        timestamp;
    private final long                        traceId;
    private final int                         orderIndex;
    private final String                      operationSignature;
    private final RuntimeStatisticInformation runtimeStatisticInformation;

    public AbstractOperationEvent(long timestamp, long traceId, int orderIndex,
            String operationSignature) {
        super();
        this.timestamp = timestamp;
        this.traceId = traceId;
        this.orderIndex = orderIndex;
        this.operationSignature = operationSignature;
        runtimeStatisticInformation = new RuntimeStatisticInformation(timestamp);
    }

    @Override
    public long getLoggingTimestamp() {
        return timestamp;
    }

    @Override
    public Class<?>[] getValueTypes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void initFromArray(Object[] arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLoggingTimestamp(long arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(IMonitoringRecord o) {
        throw new UnsupportedOperationException();
    }

    public long getTraceId() {
        return traceId;
    }

    public int getOrderIndex() {
        return orderIndex;
    }

    public String getOperationSignature() {
        return operationSignature;
    }

    public RuntimeStatisticInformation getRuntime() {
        return runtimeStatisticInformation;
    }
}
