package explorviz.worker.main

import kieker.analysis.AnalysisController
import kieker.common.configuration.Configuration
import kieker.analysis.IAnalysisController
import kieker.analysis.plugin.filter.forward.TeeFilter
import kieker.analysis.plugin.filter.forward.CountingThroughputFilter

import kieker.analysis.plugin.reader.timer.TimeReader
import explorviz.hpc_monitoring.plugin.EventRecordTraceReconstructionFilter
import explorviz.hpc_monitoring.plugin.TraceEventRecordAggregationFilter
import explorviz.hpc_monitoring.connector.RabbitMQConnector
import explorviz.hpc_monitoring.reader.TCPReader

class WorkerController {

    var IAnalysisController analysisInstance

    def start() {
        analysisInstance = new AnalysisController()

        val rabbitMQ = initRabbitMQ()
        val eventTraceReconstructionFilter = initEventRecordTraceReconstructionFilter()
//        val aggregationFilter = initAggregationFilter()
//        val timer = initTimer()
        val countingThroughputFilter = initCountingThroughputFilter()
        val teeFilter = initTeeFilter()
//        val rabbitMQConnector = initRabbitMQConnector()

        analysisInstance.connect(rabbitMQ, TCPReader::OUTPUT_PORT_NAME_RECORDS, eventTraceReconstructionFilter,
            EventRecordTraceReconstructionFilter::INPUT_PORT_NAME_TRACE_RECORDS)
            
                    analysisInstance.connect(eventTraceReconstructionFilter,
            EventRecordTraceReconstructionFilter::OUTPUT_PORT_NAME_TRACE_VALID, countingThroughputFilter,
            CountingThroughputFilter::INPUT_PORT_NAME_OBJECTS)
            
                    analysisInstance.connect(countingThroughputFilter,
            CountingThroughputFilter::OUTPUT_PORT_NAME_THROUGHPUT, teeFilter,
            TeeFilter::INPUT_PORT_NAME_EVENTS)
            
//        analysisInstance.connect(eventTraceReconstructionFilter,
//            EventRecordTraceReconstructionFilter::OUTPUT_PORT_NAME_TRACE_VALID, aggregationFilter,
//            TraceEventRecordAggregationFilter::INPUT_PORT_NAME_TRACES)
//
//        analysisInstance.connect(eventTraceReconstructionFilter,
//            EventRecordTraceReconstructionFilter::OUTPUT_PORT_NAME_TRACE_INVALID, rabbitMQConnector,
//            RabbitMQConnector::INPUT_PORT_NAME_INVALID_TRACES)
//
//        analysisInstance.connect(timer,
//            TimeReader::OUTPUT_PORT_NAME_TIMESTAMPS, aggregationFilter,
//            TraceEventRecordAggregationFilter::INPUT_PORT_NAME_TIME_EVENT)
            

//        analysisInstance.connect(aggregationFilter,
//            TraceEventRecordAggregationFilter::OUTPUT_PORT_NAME_TRACES, rabbitMQConnector,
//            RabbitMQConnector::INPUT_PORT_NAME_VALID_TRACES)

        try {
            analysisInstance.run()
        } catch (Exception e) {
            e.printStackTrace
        }
    }

    def initRabbitMQ() {
        val rabbitConfig = new Configuration()
        rabbitConfig.setProperty(TCPReader::CONFIG_PROPERTY_NAME_PROVIDERURL, "127.0.0.1")
        new TCPReader(rabbitConfig, analysisInstance)
    }
    
    def initRabbitMQConnector() {
        val rabbitConfig = new Configuration()
        rabbitConfig.setProperty(RabbitMQConnector::CONFIG_PROPERTY_NAME_PROVIDER, "localhost")
        rabbitConfig.setProperty(RabbitMQConnector::CONFIG_PROPERTY_NAME_QUEUE, "validTraces")
        new RabbitMQConnector(rabbitConfig, analysisInstance)
    }

    def initAggregationFilter() {
        val config = new Configuration()
        new TraceEventRecordAggregationFilter(config, analysisInstance)
    }

    def initTimer() {
        val config = new Configuration()
        config.setProperty(TimeReader::CONFIG_PROPERTY_VALUE_UPDATE_INTERVAL_NS, "1000000000")
        config.setProperty(TimeReader::CONFIG_PROPERTY_VALUE_DELAY_NS, "0")
        new TimeReader(config, analysisInstance)
    }
    
    def initCountingThroughputFilter() {
        val config = new Configuration()
        config.setProperty(CountingThroughputFilter::CONFIG_PROPERTY_NAME_INTERVAL_SIZE, "1000000000")
        new CountingThroughputFilter(config, analysisInstance)
    }

    def initEventRecordTraceReconstructionFilter() {
        val config = new Configuration()
        new EventRecordTraceReconstructionFilter(config, analysisInstance)
    }
    
    def initTeeFilter() {
        val config = new Configuration()
        new TeeFilter(config, analysisInstance)
    }
}
