package net.explorviz.extension.discovery.main;

import javax.ws.rs.ApplicationPath;

import org.glassfish.jersey.server.ResourceConfig;

import net.explorviz.api.ExtensionAPIImpl;
import net.explorviz.discovery.exceptions.mapper.agent.AgentInternalErrorMapper;
import net.explorviz.discovery.exceptions.mapper.agent.AgentNoConnectionMapper;
import net.explorviz.discovery.exceptions.mapper.agent.AgentNotFoundMapper;
import net.explorviz.discovery.exceptions.mapper.procezz.ProcezzGenericMapper;
import net.explorviz.discovery.model.Agent;
import net.explorviz.discovery.model.Procezz;
import net.explorviz.server.providers.JSONAPIListProvider;
import net.explorviz.server.providers.JSONAPIProvider;

@ApplicationPath("/extension/discovery")
public class Application extends ResourceConfig {

	public Application() {

		final ExtensionAPIImpl coreAPI = ExtensionAPIImpl.getInstance();

		coreAPI.registerSpecificModel("Agent", Agent.class);
		coreAPI.registerSpecificModel("Procezz", Procezz.class);

		// register DI
		register(new ExtensionDependencyInjectionBinder());

		// Exception Mapper
		register(AgentInternalErrorMapper.class);
		register(AgentNoConnectionMapper.class);
		register(AgentNotFoundMapper.class);
		register(ProcezzGenericMapper.class);

		// Enable CORS
		register(CORSResponseFilter.class);

		// register all providers in the given package
		register(JSONAPIListProvider.class);
		register(JSONAPIProvider.class);
		// packages("net.explorviz.server.providers");

		// register all resources in the given package
		packages("net.explorviz.extension.discovery.resources");
	}
}
